/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.tasks;

import io.neox.neonium.Neonium;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkGraphicsState;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderContainer;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildBuffers;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildResult;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkMeshData;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderBounds;
import me.jellysquid.mods.sodium.client.render.chunk.data.ChunkRenderData;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.tasks.ChunkRenderBuildTask;
import me.jellysquid.mods.sodium.client.render.pipeline.context.ChunkRenderCacheLocal;
import me.jellysquid.mods.sodium.client.util.MathUtil;
import me.jellysquid.mods.sodium.client.util.task.CancellationSource;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import me.jellysquid.mods.sodium.client.world.cloned.ChunkRenderContext;
import me.jellysquid.mods.sodium.common.util.WorldUtil;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.chunk.VisGraph;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldType;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.embeddedt.embeddium.api.ChunkDataBuiltEvent;
import org.embeddedt.embeddium.compat.ccl.CCLCompat;

public class ChunkRenderRebuildTask<T extends ChunkGraphicsState>
extends ChunkRenderBuildTask<T> {
    private static final BlockRenderLayer[] LAYERS = BlockRenderLayer.values();
    private final ChunkRenderContainer<T> render;
    private final BlockPos offset;
    private final ChunkRenderContext context;
    private Vec3d camera;
    private final boolean translucencySorting;

    public ChunkRenderRebuildTask(ChunkRenderContainer<T> render, ChunkRenderContext context, BlockPos offset) {
        this.render = render;
        this.offset = offset;
        this.context = context;
        this.camera = Vec3d.field_186680_a;
        this.translucencySorting = Neonium.options().advanced.translucencySorting;
    }

    public ChunkRenderRebuildTask<T> withCameraPosition(Vec3d camera) {
        this.camera = camera;
        return this;
    }

    @Override
    public ChunkBuildResult<T> performBuild(ChunkRenderCacheLocal cache, ChunkBuildBuffers buffers, CancellationSource cancellationSource) {
        ChunkRenderData.Builder renderData = new ChunkRenderData.Builder();
        VisGraph occluder = new VisGraph();
        ChunkRenderBounds.Builder bounds = new ChunkRenderBounds.Builder();
        buffers.init(renderData);
        cache.init(this.context);
        WorldSlice slice = cache.getWorldSlice();
        int baseX = this.render.getOriginX();
        int baseY = this.render.getOriginY();
        int baseZ = this.render.getOriginZ();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        BlockPos renderOffset = this.offset;
        try {
            for (int relY = 0; relY < 16; ++relY) {
                if (cancellationSource.isCancelled()) {
                    return null;
                }
                for (int relZ = 0; relZ < 16; ++relZ) {
                    for (int relX = 0; relX < 16; ++relX) {
                        TileEntitySpecialRenderer renderer;
                        TileEntity entity;
                        IBlockState blockState = slice.getBlockStateRelative(relX + 16, relY + 16, relZ + 16);
                        Block block = blockState.func_177230_c();
                        if (blockState.func_185904_a() == Material.field_151579_a) continue;
                        EnumBlockRenderType renderType = blockState.func_185901_i();
                        pos.func_181079_c(baseX + relX, baseY + relY, baseZ + relZ);
                        buffers.setRenderOffset(pos.func_177958_n() - renderOffset.func_177958_n(), pos.func_177956_o() - renderOffset.func_177956_o(), pos.func_177952_p() - renderOffset.func_177952_p());
                        if (renderType != EnumBlockRenderType.INVISIBLE) {
                            if (slice.func_175624_G() != WorldType.field_180272_g) {
                                blockState = blockState.func_185899_b((IBlockAccess)slice, (BlockPos)pos);
                            }
                            for (BlockRenderLayer layer : LAYERS) {
                                if (!block.canRenderInLayer(blockState, layer)) continue;
                                ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
                                if (CCLCompat.canHandle(renderType)) {
                                    CCLCompat.renderBlock(slice, (BlockPos)pos, blockState, buffers.get(layer));
                                    continue;
                                }
                                if (renderType == EnumBlockRenderType.MODEL && WorldUtil.toFluidBlock(block) == null) {
                                    IBakedModel model = cache.getBlockModels().func_178125_b(blockState);
                                    long seed = MathUtil.hashPos((BlockPos)pos);
                                    if (!cache.getBlockRenderer().renderModel(cache.getLocalSlice(), blockState.func_177230_c().getExtendedState(blockState, (IBlockAccess)cache.getLocalSlice(), (BlockPos)pos), (BlockPos)pos, model, buffers.get(layer), true, seed)) continue;
                                    bounds.addBlock(relX, relY, relZ);
                                    continue;
                                }
                                if (WorldUtil.toFluidBlock(block) == null || !cache.getFluidRenderer().render(cache.getLocalSlice(), blockState, (BlockPos)pos, buffers.get(layer))) continue;
                                bounds.addBlock(relX, relY, relZ);
                            }
                        }
                        if (block.hasTileEntity(blockState) && (entity = slice.func_175625_s((BlockPos)pos)) != null && (renderer = TileEntityRendererDispatcher.field_147556_a.func_147547_b(entity)) != null) {
                            renderData.addBlockEntity(entity, !renderer.func_188185_a(entity));
                            bounds.addBlock(relX, relY, relZ);
                        }
                        if (!blockState.func_185914_p()) continue;
                        occluder.func_178606_a((BlockPos)pos);
                    }
                }
            }
        }
        catch (ReportedException ex) {
            throw this.fillCrashInfo(ex.func_71575_a(), slice, (BlockPos)pos);
        }
        catch (Throwable ex) {
            throw this.fillCrashInfo(CrashReport.func_85055_a((Throwable)ex, (String)"Encountered exception while building chunk meshes"), slice, (BlockPos)pos);
        }
        ForgeHooksClient.setRenderLayer(null);
        this.render.setRebuildForTranslucents(false);
        for (BlockRenderPass pass : BlockRenderPass.VALUES) {
            ChunkMeshData mesh = buffers.createMesh(pass, (float)this.camera.field_72450_a - (float)this.offset.func_177958_n(), (float)this.camera.field_72448_b - (float)this.offset.func_177956_o(), (float)this.camera.field_72449_c - (float)this.offset.func_177952_p(), this.translucencySorting);
            if (mesh == null) continue;
            renderData.setMesh(pass, mesh);
            if (!this.translucencySorting || !pass.isTranslucent()) continue;
            this.render.setRebuildForTranslucents(true);
        }
        renderData.setOcclusionData(occluder.func_178607_a());
        renderData.setBounds(bounds.build(this.render.getChunkPos()));
        MinecraftForge.EVENT_BUS.post((Event)new ChunkDataBuiltEvent(renderData));
        return new ChunkBuildResult<T>(this.render, renderData.build());
    }

    private ReportedException fillCrashInfo(CrashReport report, WorldSlice slice, BlockPos pos) {
        CrashReportCategory crashReportSection = report.func_85057_a("Block being rendered", 1);
        IBlockState state = null;
        try {
            state = slice.func_180495_p(pos);
        }
        catch (Exception exception) {
            // empty catch block
        }
        CrashReportCategory.func_175750_a((CrashReportCategory)crashReportSection, (BlockPos)pos, (IBlockState)state);
        crashReportSection.func_71507_a("Chunk section", this.render);
        if (this.context != null) {
            crashReportSection.func_71507_a("Render context volume", (Object)this.context.getVolume());
        }
        return new ReportedException(report);
    }

    @Override
    public void releaseResources() {
        this.context.releaseResources();
    }
}

